IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_PROD_BALAN_IT_CODIGO_BARRAS')
BEGIN
	DROP TRIGGER TRG_EST_PROD_BALAN_IT_CODIGO_BARRAS
END
GO
CREATE TRIGGER [dbo].[TRG_EST_PROD_BALAN_IT_CODIGO_BARRAS] ON [dbo].[EST_PROD_BALAN_IT] FOR UPDATE AS
IF UPDATE(QT_IT_BALAN)
begin
	IF EXISTS(SELECT 
					CD_PROD
				FROM 
					INSERTED
			    WHERE 
					QT_IT_BALAN>999999)
	  begin
		RAISERROR ('Produto com a quantidade de estoque fora do padrao, pela analise esta sendo atualizado com numeros de codigos de barras.',16, 1); 
		RETURN;
	  end
end

GO

ALTER TABLE [dbo].[EST_PROD_BALAN_IT] ENABLE TRIGGER [TRG_EST_PROD_BALAN_IT_CODIGO_BARRAS]
GO


